﻿using System;

namespace ScrumRobot
{
  class Program
  {
    private static VSOManager vsoManager = new VSOManager();
    static void SetupTeamProject()
    {
      Console.WriteLine("");
      Console.Write(" Remove existing areas and create new ones? (y/n): ");
      ConsoleKeyInfo info = Console.ReadKey();
      Console.WriteLine("");
      if (info.KeyChar == 'y' || info.KeyChar == 'Y')
      {
        Console.WriteLine("");
        Console.Write(" Removing areas");
        vsoManager.RemoveAreas();
        Console.Write(" Creating areas ");
        vsoManager.CreateAreas();
      }

      Console.WriteLine("");
      Console.Write(" Remove existing Sprints and create new ones? (y/n): ");
      info = Console.ReadKey();
      Console.WriteLine("");
      if (info.KeyChar == 'y' || info.KeyChar == 'Y')
      {
        Console.WriteLine("");
        Console.Write(" Removing Sprints ");
        vsoManager.RemoveSprints();
        Console.Write(" Creating Sprints ");
        vsoManager.CreateSprints();
        Console.Write(" Setting Sprints for planning ");
        vsoManager.SetPlanningSprints();
      }

      Console.WriteLine("");
      Console.Write(" Destroy all existing work items and create new PBIs? (y/n): ");
      info = Console.ReadKey();
      Console.WriteLine("");
      if (info.KeyChar == 'y' || info.KeyChar == 'Y')
      {
        Console.WriteLine("");
        Console.Write(" Destroying work items ");
        vsoManager.DestroyAllWorkItems();
        Console.Write(" Creating PBIs ");
        vsoManager.CreatePBIs();
      }

      Console.WriteLine("");
      Console.Write(" Destroy all tasks and create Sprint 1 plan (tasks)? (y/n): ");
      info = Console.ReadKey();
      Console.WriteLine("");
      if (info.KeyChar == 'y' || info.KeyChar == 'Y')
      {
        Console.WriteLine("");
        Console.Write(" Destroying all tasks");
        vsoManager.DestroyTasks();
        Console.Write(" Reseting the Product Backlog");
        vsoManager.ResetProductBacklog();
        Console.Write(" Creating Sprint 1 Forecast");
        vsoManager.Sprint1Forecast();
        Console.Write(" Creating Sprint 1 plan");
        vsoManager.Sprint1Plan();
      }
    }
    static void Main(string[] args)
    {
      try
      {
        vsoManager = new VSOManager();

        Console.WriteLine("PSD ScrumRobot v1.0");
        Console.WriteLine("");
        Console.WriteLine(" Account URL ............. " + vsoManager.AccountURL);
        Console.WriteLine(" Project ................. " + vsoManager.TeamProject);
        Console.WriteLine(" Microsoft Account ....... " + vsoManager.MicrosoftAccountAlias);
        Console.WriteLine(" Password ................ " + vsoManager.MicrosoftAccountPassword);
        Console.WriteLine(" XML Input file (Areas) .. " + vsoManager.InputFileAreas);
        Console.WriteLine(" XML Input file (PB) ..... " + vsoManager.InputFileProductBacklog);
        Console.WriteLine(" XML Input file (SB) ..... " + vsoManager.InputFileSprintBacklog);
        Console.WriteLine(" Product Owner ........... " + vsoManager.ProductOwner);
        Console.WriteLine("");

        // Confirm input

        Console.Write("Is the above information correct? (y/n): ");
        ConsoleKeyInfo info = Console.ReadKey();
        Console.WriteLine("");
        if (info.KeyChar != 'y' && info.KeyChar != 'Y')
        {
          Console.WriteLine("");
          Console.WriteLine("Please edit the app.config file and make any necessary changes.");
          return;
        }
        SetupTeamProject();
      }
      catch (Exception ex)
      {
        Console.WriteLine("Error: " + ex.Message);
      }
      finally
      {
        Console.WriteLine("");
        Console.WriteLine("Press Enter to continue.");
        Console.ReadLine();
      }
    }
  }
}